
// Digital Face - LP23.com
// Copyright  Luigi Pino. All rights reserved.

/***************************************************************************/

#include "../neurosis/neurosis.h"
#include "extra.h"

/***************************************************************************/

extern CNeurosisCamera			gCamera;
extern CNeurosisController	gController;
extern CNeurosisModel				gEyeballLeftModel;
extern CNeurosisModel				gEyeballRightModel;
extern CNeurosisModel				gFaceModel;
extern CNeurosisTiming			gTiming;
extern CNeurosisWindow			gWindow;

/***************************************************************************/

void Draw_Scene()

{
	glLoadIdentity();
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
	glTranslatef(gCamera.mPositionCurrent.x, gCamera.mPositionCurrent.y, gCamera.mPositionCurrent.z);
	glRotatef(gCamera.mAxisCurrent.y, 0.0f, 1.0f, 0.0f);
	glRotatef(gCamera.mAxisCurrent.x, 1.0f, 0.0f, 0.0f);

	gFaceModel.Render();
	gEyeballLeftModel.Render();
	gEyeballRightModel.Render();

	gWindow.Font_Begin(TEXTURE_FONT);
	gWindow.Font_List_Print(2.0f, 3.0f, 2.0f, 1.0f, 1.0f, 0.0f, false, false, "Digital Face");
	gWindow.Font_List_Print(98.0f, 3.0f, 2.0f, 1.0f, 1.0f, 0.0f, false, true, "LP23.com");
	gWindow.Font_End();
}

/***************************************************************************/

void Initialize_Textures()

{
	if ((gWindow.Font_List_Load("data/textures/font_list.txt") == false) ||
			(gWindow.Texture_Load("data/textures/font.png", TEXTURE_FONT) == -1) ||
			(gFaceModel.File_Load("data/models/face.dat") == false))
	{
		MessageBox(NULL, "Could not initialize game resources.", "Digital Face", MB_OK | MB_ICONERROR);
		exit(EXIT_FAILURE);
	}

	// Left eye
	gEyeballLeftModel.File_Load("data/models/eye.dat");
	gEyeballLeftModel.Move(&float3(-2.6f, 2.5f, 6.0f));
	gEyeballLeftModel.Rotate_y(170.0f);

	// Right eye
	gEyeballRightModel.File_Load("data/models/eye.dat");
	gEyeballRightModel.Move(&float3(2.6f, 2.5f, 6.0f));
	gEyeballRightModel.Rotate_y(190.0f);
}

/***************************************************************************/

void Initialize_System()

{
	srand((unsigned)time(NULL));
	gCamera.mAxisCurrent.x = 0.0f;
	gCamera.mAxisCurrent.y = 180.0f;
	gCamera.mPositionCurrent.z = -50.0f;
}

/***************************************************************************/

void Update_Keyboard()

{
	float3 moveUp(0.0f, 2.0f * gTiming.Get_Time_Step(), 0.0f);
	float3 moveDown(0.0f, -2.0f * gTiming.Get_Time_Step(), 0.0f);
	float3 moveLeft(-2.0f * gTiming.Get_Time_Step(), 0.0f, 0.0f);
	float3 moveRight(2.0f * gTiming.Get_Time_Step(), 0.0f, 0.0f);

	if (gWindow.pKeys[VK_LEFT])
	{
		gEyeballLeftModel.Rotate_y(80.0f * gTiming.Get_Time_Step());
		gEyeballRightModel.Rotate_y(80.0f * gTiming.Get_Time_Step());
	}
	else if (gWindow.pKeys[VK_RIGHT])
	{
		gEyeballLeftModel.Rotate_y(-80.0f * gTiming.Get_Time_Step());
		gEyeballRightModel.Rotate_y(-80.0f * gTiming.Get_Time_Step());
	}

	if (gWindow.pKeys[VK_UP])
	{
		gEyeballLeftModel.Rotate_x(80.0f * gTiming.Get_Time_Step());
		gEyeballRightModel.Rotate_x(80.0f * gTiming.Get_Time_Step());
	}
	else if (gWindow.pKeys[VK_DOWN])
	{
		gEyeballLeftModel.Rotate_x(-80.0f * gTiming.Get_Time_Step());
		gEyeballRightModel.Rotate_x(-80.0f * gTiming.Get_Time_Step());
	}

	// Zoom
	if ((gWindow.pKeys[VK_ADD]) && (gCamera.mPositionCurrent.z < -15.0f))
		gCamera.mPositionCurrent.z = gCamera.mPositionCurrent.z + (100.0f * gTiming.Get_Time_Step());
	if ((gWindow.pKeys[VK_SUBTRACT]) && (gCamera.mPositionCurrent.z > -100.0f))
		gCamera.mPositionCurrent.z = gCamera.mPositionCurrent.z - (100.0f * gTiming.Get_Time_Step());

	// Upper lip
	if (gWindow.pKeys['A'])
		gFaceModel.pPoints[42].mPosition = gFaceModel.pPoints[42].mPosition + moveUp;
	else if (gWindow.pKeys['Z'])
		gFaceModel.pPoints[42].mPosition = gFaceModel.pPoints[42].mPosition + moveDown;

	// Lower lip
	if (gWindow.pKeys['S'])
		gFaceModel.pPoints[43].mPosition = gFaceModel.pPoints[43].mPosition + moveUp;
	else if (gWindow.pKeys['X'])
		gFaceModel.pPoints[43].mPosition = gFaceModel.pPoints[43].mPosition + moveDown;

	// Sides of mouth
	if (gWindow.pKeys['C'])
	{
		gFaceModel.pPoints[38].mPosition = gFaceModel.pPoints[38].mPosition + moveRight;
		gFaceModel.pPoints[83].mPosition = gFaceModel.pPoints[83].mPosition + moveLeft;
	}
	else if (gWindow.pKeys['D'])
	{
		gFaceModel.pPoints[38].mPosition = gFaceModel.pPoints[38].mPosition + moveLeft;
		gFaceModel.pPoints[83].mPosition = gFaceModel.pPoints[83].mPosition + moveRight;
	}

	// Upper eyelid
	if (gWindow.pKeys['F'])
	{
		gFaceModel.pPoints[10].mPosition = gFaceModel.pPoints[10].mPosition + moveUp;
		gFaceModel.pPoints[58].mPosition = gFaceModel.pPoints[58].mPosition + moveUp;
	}
	else if (gWindow.pKeys['V'])
	{
		gFaceModel.pPoints[10].mPosition = gFaceModel.pPoints[10].mPosition + moveDown;
		gFaceModel.pPoints[58].mPosition = gFaceModel.pPoints[58].mPosition + moveDown;
	}

	// Lower eyelid
	if (gWindow.pKeys['G'])
	{
		gFaceModel.pPoints[16].mPosition = gFaceModel.pPoints[16].mPosition + moveUp;
		gFaceModel.pPoints[63].mPosition = gFaceModel.pPoints[63].mPosition + moveUp;
	}
	else if (gWindow.pKeys['B'])
	{
		gFaceModel.pPoints[16].mPosition = gFaceModel.pPoints[16].mPosition + moveDown;
		gFaceModel.pPoints[63].mPosition = gFaceModel.pPoints[63].mPosition + moveDown;
	}
}

/***************************************************************************/

void Update_Mouse()

{
	// Update mouse values
	gController.Update(gTiming.Get_Time_Step(), false);

	// Face rotation
	if (gController.mButton[0].x > 0.0f)
	{
		if (gController.mMouse.mChange.x != 0.0f)
			gCamera.mAxisCurrent.y = gCamera.mAxisCurrent.y - (gController.mMouse.mChange.x * 100.0f * gTiming.Get_Time_Step());
		if (gController.mMouse.mChange.y != 0.0f)
			gCamera.mAxisCurrent.x = gCamera.mAxisCurrent.x + (gController.mMouse.mChange.y * 100.0f * gTiming.Get_Time_Step());
	}
}

/***************************************************************************/